import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.15
import SMC.Controllers 1.0
import styles 1.0

Frame {
    id: root
    required property QmlTranscriptionController controller

    Layout.fillWidth: true
    padding: Theme.spacingLg

    background: Rectangle {
        radius: Theme.panelRadius
        color: Theme.surfaceStrong
        border.color: Theme.surfaceBorder
    }

    contentItem: ColumnLayout {
        spacing: Theme.spacingSm

        RowLayout {
            Layout.fillWidth: true
            spacing: Theme.spacingSm

            Label {
                text: qsTr("Status") + ": " + (root.controller && root.controller.status ? root.controller.status : qsTr("Unavailable"))
                color: Theme.textPrimary
            }

            Item { Layout.fillWidth: true }

            Label {
                text: root.controller && root.controller.busy ? qsTr("Processing…") : qsTr("Idle")
                color: root.controller && root.controller.busy ? Theme.accent : Theme.textSecondary
            }
        }

        ProgressBar {
            Layout.fillWidth: true
            from: 0
            to: 100
            value: root.controller && root.controller.progress !== undefined ? root.controller.progress : 0
        }

        Label {
            visible: root.controller && root.controller.downloadMessage && root.controller.downloadMessage.length > 0
            text: root.controller && root.controller.downloadMessage ? root.controller.downloadMessage : ""
            color: Theme.textSecondary
            wrapMode: Text.WordWrap
        }

    }
}
