import QtQuick 2.15
import QtQuick.Controls 2.15
import styles 1.0
import SMC.Components 1.0

Item {
    id: root
    implicitWidth: 640
    implicitHeight: 240

    required property var appWorkspaceController
    readonly property var appController: root.appWorkspaceController

    // Fit box computes aspect-correct size for the video surface
    Item {
        id: fitBox
        anchors.fill: parent
        anchors.margins: Theme.spacingSm
        clip: false  // Allow detection overlay handles to extend beyond video bounds

        // Video's native dimensions (fallbacks avoid divide-by-zero)
        readonly property real nativeW: Math.max(1, (videoSurface && videoSurface.imageWidth) || 0)
        readonly property real nativeH: Math.max(1, (videoSurface && videoSurface.imageHeight) || 0)
        readonly property real scale: Math.min(width / nativeW, height / nativeH)

        VideoTextureItem {
            id: videoSurface
            objectName: "playerVideoSurface"
            anchors.centerIn: parent
            width: Math.round(fitBox.nativeW * fitBox.scale)
            height: Math.round(fitBox.nativeH * fitBox.scale)
            frameCache: root.appController ? root.appController.frameCache : null
            playbackController: root.appController ? root.appController.playbackController : null
            frameIndex: (function() {
                if (!root.appController)
                    return -1
                if (root.appController.mediaStatus !== "ready")
                    return -1
                if (!root.appController.hasVideo)
                    return -1
                var t = root.appController.playbackPosition
                return root.appController.frameIndexAtTime(t)
            })()
        }

        DetectionAreaOverlay {
            id: detectionOverlay
            anchors.fill: videoSurface
            z: 10  // Above video surface
            analysisController: root.appController ? root.appController.analysisController : null
        }

        Label {
            anchors.centerIn: parent
            text: (!root.appController || root.appController.mediaStatus === "loading")
                    ? qsTr("Loading preview…")
                    : qsTr("No frame available")
            color: Theme.textSecondary
            visible: !videoSurface || !videoSurface.hasFrame
            horizontalAlignment: Text.AlignHCenter
            wrapMode: Text.WordWrap
        }
    }
}
