pragma ComponentBehavior: Bound

import QtQuick 2.15

/*
  WorkspaceViewPreferences: Encapsulates view preference loading/syncing.

  Usage:
    WorkspaceViewPreferences {
        id: viewPrefs
        settingsModel: root.settingsModel
        workspaceKey: "cut"
    }

  Then reference viewPrefs.prefs.showToolsSidebar, etc.

  Defaults are defined centrally in ViewDefaults.qml - do not pass defaults per-instance.
*/
QtObject {
    id: root

    required property var settingsModel
    required property string workspaceKey

    // Current preference values (reactive)
    property var prefs: ({})

    function _applyConfig(cfg) {
        if (!cfg) cfg = {}
        var wsDefaults = ViewDefaults.all[workspaceKey] || {}
        var result = {}
        for (var key in wsDefaults) {
            result[key] = cfg.hasOwnProperty(key) ? !!cfg[key] : wsDefaults[key]
        }
        prefs = result
    }

    Component.onCompleted: {
        if (settingsModel) {
            _applyConfig(settingsModel.workspace_view(workspaceKey))
        }
    }

    property Connections _settingsConnection: Connections {
        target: root.settingsModel || null
        function onWorkspace_view_changed(wk, values) {
            if (wk === root.workspaceKey) {
                root._applyConfig(values)
            }
        }
    }
}
