pragma Singleton

import QtQuick 2.15

/*
  ViewDefaults: Single source of truth for workspace view defaults.

  Usage from QML:
    import components.workspace 1.0
    ...
    ViewDefaults.getDefault("cut", "showFrameStrip")  // returns false
*/
QtObject {
    // Global defaults - THE source of truth for all workspace view settings.
    // Edit these values to change defaults across the entire app.
    readonly property var all: ({
        "cut": {
            "showToolsSidebar": true,
            "showFrameStrip": false,
            "showOverviewTimeline": true,
            "showAudioTimeline": true,
            "showPlayheadInfo": false,
            "showCutActionsToolbar": true,
            "showFileListPanel": false
        },
        "transcribe": {
            "showOverviewTimeline": true,
            "showAudioTimeline": true
        },
        "audiomix": {
            "showOverviewTimeline": true,
            "showAudioTimeline": true
        },
        "join": {
            "showAudioTimeline": true
        }
    })

    // Get default value for a specific workspace and flag.
    function getDefault(workspace, flag) {
        var ws = all[workspace]
        return ws && ws.hasOwnProperty(flag) ? ws[flag] : false
    }
}
