pragma ComponentBehavior: Bound

import QtQuick 2.15
import styles 1.0

Item {
    id: root

    // Default dimensions - can be overridden
    implicitWidth: 400
    implicitHeight: toastColumn.implicitHeight

    // Show a toast message
    // type: "success", "error", "warning", or "info"
    // duration: auto-dismiss time in ms (default 3000, 0 = no auto-dismiss)
    // detail: optional second line with more information
    function show(message: string, type: string, duration: int, detail: string): void {
        if (duration === undefined) duration = 3000
        if (detail === undefined) detail = ""
        toastModel.append({
            modelMessage: message,
            modelDetail: detail || "",
            modelToastType: type || "info",
            modelDuration: duration
        })
    }

    // Convenience methods
    function success(message: string, detail: string): void {
        show(message, "success", 3000, detail || "")
    }

    function error(message: string, detail: string): void {
        show(message, "error", 5000, detail || "")  // Errors stay longer
    }

    function warning(message: string, detail: string): void {
        show(message, "warning", 4000, detail || "")
    }

    function info(message: string, detail: string): void {
        show(message, "info", 3000, detail || "")
    }

    ListModel {
        id: toastModel
    }

    Column {
        id: toastColumn
        anchors.right: parent.right
        anchors.top: parent.top
        spacing: Theme.spacingSm

        Repeater {
            model: toastModel

            Toast {
                id: toastItem
                required property int index
                required property string modelMessage
                required property string modelDetail
                required property string modelToastType
                required property int modelDuration

                message: toastItem.modelMessage
                detail: toastItem.modelDetail
                toastType: toastItem.modelToastType
                duration: toastItem.modelDuration

                onDismissed: {
                    // Slide out then remove
                    x = 300
                    removeTimer.start()
                }

                Timer {
                    id: removeTimer
                    interval: 250  // Wait for slide animation
                    onTriggered: toastModel.remove(toastItem.index)
                }
            }
        }
    }
}
