import QtQuick 2.15
import QtQuick.Shapes 1.15
import styles 1.0

Item {
    id: root
    property var waveformData: []
    property string waveformPath: ""
    property color fillColor: Theme.accent
    property color peakColor: Qt.lighter(fillColor, 1.6)
    property color backgroundColor: Theme.timelineBackground
    property color borderColor: Theme.surfaceBorder

    clip: true

    Rectangle {
        anchors.fill: parent
        color: root.backgroundColor
        border.color: root.borderColor
        border.width: 1
        visible: border.width > 0
    }

    Shape {
        id: waveformShape
        anchors.fill: parent
        antialiasing: true
        visible: root.waveformPath.length > 0
        layer.enabled: true
        layer.smooth: true
        layer.samples: 4

        ShapePath {
            id: shapePath
            strokeWidth: 0
            strokeColor: "transparent"
            fillRule: ShapePath.WindingFill

            fillGradient: LinearGradient {
                y1: 0
                y2: waveformShape.height
                GradientStop { position: 0.0; color: root.peakColor }
                GradientStop { position: 1.0; color: root.fillColor }
            }

            PathSvg {
                path: root.waveformPath
            }
        }
    }

    function updateWaveformPath() {
        var data = root.waveformData
        var h = root.height

        if (!data || data.length === 0 || h <= 0) {
            root.waveformPath = ""
            return
        }

        var clampedHeight = h
        var parts = []
        parts.push("M 0 " + clampedHeight)
        for (var i = 0; i < data.length; ++i) {
            var y = data[i]
            if (y < 0) {
                y = 0
            } else if (y > clampedHeight) {
                y = clampedHeight
            }
            parts.push("L " + i + " " + y)
        }
        parts.push("L " + data.length + " " + clampedHeight)
        parts.push("Z")

        root.waveformPath = parts.join(" ")
    }

    onWaveformDataChanged: updateWaveformPath()
    onHeightChanged: updateWaveformPath()
    Component.onCompleted: updateWaveformPath()
}
