import QtQuick 2.15
import QtQuick.Controls 2.15

pragma ComponentBehavior: Bound

Item {
    id: root
    property var speeds: [0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 2.0, 3.0, 4.0, 6.0, 8.0]
    property alias currentIndex: combo.currentIndex
    property real currentSpeed: speeds[combo.currentIndex]
    signal speedChanged(real value)

    implicitWidth: combo.implicitWidth
    implicitHeight: combo.implicitHeight

    ComboBox {
        id: combo
        anchors.fill: parent
        model: root.speeds
        hoverEnabled: true
        focusPolicy: Qt.NoFocus
        displayText: root.currentSpeed + "x"
        textRole: "display"
        delegate: ItemDelegate {
            required property var modelData
            text: modelData + "x"
            width: combo.width
        }
        onActivated: (index) => root.speedChanged(root.speeds[index])
        onCurrentIndexChanged: root.speedChanged(root.speeds[currentIndex])
        Component.onCompleted: {
            var idx = root.speeds.indexOf(1.0)
            combo.currentIndex = idx >= 0 ? idx : 0
        }
    }

    function increaseSpeed() {
        if (combo.currentIndex < speeds.length - 1) {
            combo.currentIndex += 1
            root.speedChanged(speeds[combo.currentIndex])
        }
    }

    function decreaseSpeed() {
        if (combo.currentIndex > 0) {
            combo.currentIndex -= 1
            root.speedChanged(speeds[combo.currentIndex])
        }
    }
}
