import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.15
import styles 1.0

Frame {
    id: root
    property string title: ""
    property string statusText: ""
    property bool active: false

    default property alias trailingContent: trailingRow.data

    Layout.fillWidth: true
    padding: Theme.spacingLg

    background: Rectangle {
        radius: Theme.panelRadius
        color: Theme.surfaceStrong
        border.color: Theme.surfaceBorder
    }

    contentItem: RowLayout {
        spacing: Theme.spacingLg

        Label {
            text: root.title
            color: Theme.textPrimary
            font.pixelSize: 20
            Layout.alignment: Qt.AlignVCenter
        }

        Rectangle {
            Layout.preferredWidth: 4
            Layout.preferredHeight: 4
            radius: 2
            color: root.active ? Theme.accent : Theme.textSecondary
            Layout.alignment: Qt.AlignVCenter
        }

        Label {
            text: root.statusText
            color: Theme.textSecondary
            font.pixelSize: 14
            Layout.alignment: Qt.AlignVCenter
        }

        Item { Layout.fillWidth: true }

        RowLayout {
            id: trailingRow
            spacing: Theme.spacingSm
            Layout.alignment: Qt.AlignRight | Qt.AlignVCenter
        }
    }
}
