import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.15
import styles 1.0

RowLayout {
    id: root
    property alias title: titleLabel.text
    property string subtitle: ""
    default property alias actions: actionRow.data
    property color titleColor: Theme.textPrimary
    property color subtitleColor: Theme.textSecondary

    spacing: 12
    Layout.fillWidth: true

    ColumnLayout {
        Layout.fillWidth: true
        spacing: root.subtitle.length > 0 ? 2 : 0

        Label {
            id: titleLabel
            text: "Section"
            font.pixelSize: 18
            font.bold: true
            color: root.titleColor
            elide: Label.ElideRight
            Layout.fillWidth: true
        }

        Label {
            visible: root.subtitle.length > 0
            text: root.subtitle
            font.pixelSize: 13
            color: root.subtitleColor
            elide: Label.ElideRight
            Layout.fillWidth: true
        }
    }

    RowLayout {
        id: actionRow
        spacing: 6
        Layout.alignment: Qt.AlignRight | Qt.AlignVCenter
    }
}
