import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.15
import styles 1.0

Item {
    id: root
    required property string title

    Layout.fillWidth: true
    Layout.preferredHeight: 48
    implicitHeight: 48

    // Transparent background - parent Card provides the surface color
    Label {
        anchors.fill: parent
        anchors.leftMargin: Theme.spacingLg
        anchors.rightMargin: Theme.spacingLg
        text: root.title
        color: Theme.textPrimary
        font.pixelSize: 16
        font.weight: Font.DemiBold
        verticalAlignment: Text.AlignVCenter
        elide: Text.ElideRight
    }

    Rectangle {
        anchors.bottom: parent.bottom
        anchors.left: parent.left
        anchors.right: parent.right
        height: 1
        color: Theme.surfaceBorder
    }
}
