import QtQuick 2.15
import QtQuick.Controls 2.15
import styles 1.0

// Neutral, outlined secondary action
Button {
    id: control
    implicitHeight: 36
    font.pixelSize: 14
    padding: Theme.spacingSm
    focusPolicy: Qt.TabFocus
    flat: true

    contentItem: Label {
        text: control.text
        font: control.font
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        elide: Text.ElideRight
        color: control.enabled ? Theme.textPrimary : Theme.textSecondary
    }

    background: Rectangle {
        radius: Theme.panelRadius
        color: control.down
               ? Theme._mix(Theme.surfaceStrong, Theme._black, Theme.isDark ? 0.15 : 0.06)
               : (control.hovered
                    ? Theme._mix(Theme.surfaceStrong, Theme._white, Theme.isDark ? 0.05 : 0.08)
                    : Theme.surface)
        border.width: 1
        border.color: Theme.surfaceBorder
    }
}
