pragma ComponentBehavior: Bound

import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.15

import styles 1.0

// Slider with a formatted value label on the right.
// Replaces SpinBox to avoid focus/commit timing issues.
RowLayout {
    id: root

    // Slider properties exposed via aliases
    property alias value: slider.value
    property alias from: slider.from
    property alias to: slider.to
    property alias stepSize: slider.stepSize

    // Display formatting
    property string suffix: ""        // e.g. " dB", " s", "%"
    property int decimals: 0          // decimal places to show
    property real displayScale: 1.0   // multiply value for display (e.g. 0.1 for tenths)

    spacing: Theme.spacingSm

    Slider {
        id: slider
        Layout.fillWidth: true
        stepSize: 1
    }

    Label {
        Layout.minimumWidth: 30
        horizontalAlignment: Text.AlignRight
        text: (root.value * root.displayScale).toFixed(root.decimals) + root.suffix
        font.pixelSize: 13
        color: Theme.textSecondary
    }
}
