import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Controls.impl 2.15 as ControlsImpl
import QtQuick.Layouts 1.15
import Qt5Compat.GraphicalEffects
import styles 1.0

AbstractButton {
    id: button
    property url iconSource: ""
    property bool showPremiumBadge: false

    implicitHeight: 40
    leftPadding: 16
    rightPadding: 16
    checkable: false
    font.pixelSize: 13
    font.weight: button.checked ? Font.DemiBold : Font.Normal
    
    // Hover handling
    hoverEnabled: true

    contentItem: RowLayout {
        anchors.centerIn: parent
        spacing: 8

        Item {
            Layout.alignment: Qt.AlignVCenter
            implicitWidth: 20
            implicitHeight: 20
            visible: button.iconSource !== ""

            ControlsImpl.IconImage {
                anchors.fill: parent
                source: button.iconSource
                color: button.checked ? Theme.accent : (button.hovered ? Theme.textPrimary : Theme.textSecondary)
                Behavior on color { ColorAnimation { duration: 150 } }
            }

            // Premium badge (small crown in corner)
            Item {
                visible: button.showPremiumBadge
                anchors.right: parent.right
                anchors.top: parent.top
                anchors.rightMargin: -4
                anchors.topMargin: -4
                width: 12
                height: 12

                Image {
                    id: crownIcon
                    anchors.fill: parent
                    source: Theme.iconUrl("crown")
                    sourceSize.width: 12
                    sourceSize.height: 12
                    visible: false
                }

                ColorOverlay {
                    anchors.fill: crownIcon
                    source: crownIcon
                    color: "#ffb800"
                }
            }
        }

        Label {
            Layout.alignment: Qt.AlignVCenter
            text: button.text
            font: button.font
            color: button.checked ? Theme.textPrimary : (button.hovered ? Theme.textPrimary : Theme.textSecondary)
            Behavior on color { ColorAnimation { duration: 150 } }
        }
    }

    background: Rectangle {
        color: button.hovered && !button.checked ? Theme.surfaceRaised : "transparent"
        radius: 4
        
        // Active indicator line at the bottom
        Rectangle {
            anchors.bottom: parent.bottom
            anchors.horizontalCenter: parent.horizontalCenter
            width: button.checked ? parent.width - 16 : 0
            height: 3
            radius: 1.5
            color: Theme.accent
            
            Behavior on width { NumberAnimation { duration: 200; easing.type: Easing.OutQuad } }
        }
    }
}
