import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.15
import styles 1.0

pragma ComponentBehavior: Bound

Control {
    id: root
    property var model: []
    property int currentIndex: 0
    property string caption: ""
    property var licenseManager: null
    signal tabRequested(int index)

    implicitHeight: 44
    padding: 0

    background: Rectangle {
        color: Theme.surface
        Rectangle {
            anchors.top: parent.top
            anchors.left: parent.left
            anchors.right: parent.right
            height: 1
            color: Theme.surfaceBorder
        }
    }

    contentItem: Item {
        anchors.fill: parent

        RowLayout {
            anchors.fill: parent
            anchors.leftMargin: Theme.spacingLg
            anchors.rightMargin: Theme.spacingLg
            spacing: Theme.spacingSm

            // Left spacer to push tabs to center
            Item {
                Layout.fillWidth: true
            }

            // Centered Tabs
            RowLayout {
                Layout.alignment: Qt.AlignVCenter
                spacing: Theme.spacingMd // Increased spacing for cleaner look

                Repeater {
                    model: root.model ? root.model.length : 0

                    delegate: BottomTabButton {
                        required property int index
                        property var tabEntry: root.model[index]
                        objectName: tabEntry && tabEntry.key ? tabEntry.key + "Tab" : ""
                        Layout.fillHeight: true
                        text: tabEntry && tabEntry.label ? tabEntry.label : ""
                        iconSource: tabEntry && tabEntry.icon ? tabEntry.icon : ""
                        checked: root.currentIndex === index
                        showPremiumBadge: (tabEntry && tabEntry.premium) ? !root.licenseManager || !root.licenseManager.isValid() : false
                        onClicked: root.tabRequested(index)
                    }
                }
            }

            // Right spacer
            Item {
                Layout.fillWidth: true
            }
            
            // Version caption on the far right, subtle
            Label {
                text: root.caption
                visible: text.length > 0
                Layout.alignment: Qt.AlignVCenter
                color: Theme.textSecondary
                font.pixelSize: 11
                opacity: 0.7
            }
        }
    }
}
