# Smart Media Cutter – QML Guide

### Directory structure

```
qml/
├── AppRoot.qml           # Main window, palette, shortcuts
├── styles/
│   └── Theme.qml         # Colors, spacing tokens (singleton)
├── features/             # Workspace-specific views
│   ├── cut/              # Cut workspace (timeline, actions)
│   ├── transcription/    # Transcription workspace
│   ├── player/           # Video player components
│   ├── export/           # Export overlay
│   └── settings/         # Settings overlay, shortcut editor
├── components/           # Reusable components
│   ├── controls/         # Buttons, toggles, undo history
│   ├── media/            # Timeline, waveform, player controls
│   ├── layout/           # Cards, section headers
│   └── forms/            # Labeled fields
└── icons/                # SVG icons (use Theme.iconUrl("name"))
```

### Theme system

Import `styles 1.0` and use `Theme` tokens:

```qml
import styles 1.0

Rectangle {
    color: Theme.surface
    border.color: Theme.surfaceBorder

    Text {
        color: Theme.textPrimary
        // Also: textSecondary
    }
}
```

**Colors**: `background`, `surface`, `surfaceRaised`, `textPrimary`, `textSecondary`, `accent`, `selectionHighlight`, `statusDanger`

**Spacing**: `spacingXs` (4), `spacingSm` (8), `spacingMd` (12), `spacingLg` (16), `spacingXl` (24)

**Accent**: Orange in dark theme, blue in light theme. Use for interactive elements.

**Icons**: `Theme.iconUrl("icon-name")` returns path to SVG in `icons/`

### Imports and typing

```qml
import QtQuick
import QtQuick.Controls
import QtQuick.Layouts
import styles 1.0
import SMC.Controllers 1.0  // For Python controller types
```

Use `required property` for controller bindings:
```qml
required property var workspaceController
```

### Layout rules

- Prefer `RowLayout/ColumnLayout/GridLayout` over anchors
- Never mix layouts with anchors on the same item
- Use `Layout.fillWidth`, `Layout.preferredHeight`, etc.

### Data flow

- Views bind to controller properties and call controller slots
- Avoid logic in QML; keep it in Python controllers
- Avoid unqualified global references; create local typed properties

### Reusable components

- `PrimaryButton`, `SecondaryButton`, `IconButton` – styled buttons
- `AudioTimeline` – waveform + selection + cuts overlay
- `UndoHistoryButton` – dropdown for undo history navigation
- `Card`, `SectionHeader` – layout containers

### Quality gate

```bash
source ./venv/bin/activate
./check-code-quality.sh  # Includes pyside6-qmllint
```
